package fr.inria.sampleapp;

import java.util.ArrayList;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class ContactDataSource {
	private SQLiteOpenHelper dbHelper;
	private SQLiteDatabase database;
	
	private Context context;
	public ContactDataSource(Context c){
		this.context=c;
	}
	
	public void openDatabase(){
		this.dbHelper = new InriaSqliteHelper(this.context);
		this.database=this.dbHelper.getWritableDatabase();
	}
	
	public void closeDatabase(){
		this.database.close();
	}
	public void addContact(ContactModel contact){
	    ContentValues data=new ContentValues();
	    data.put("name", contact.getName());
	    data.put("sex", contact.getSex().name());
	    data.put("city", contact.getCity());
	    data.put("team", contact.getTeam());
	    data.put("phone", contact.getPhone());
	    data.put("detail", contact.getDetail());
	    this.database.insert(InriaSqliteHelper.CONTACT_TABLE, null, data);
	}
	
	
	//DRY, Don't Repeat Yourself!!! Code to refactor
	public ContactModel getContact(int contact_id){
		ContactModel contact=null;
		String selection_values[]={""+contact_id};
		Cursor cursor=this.database.query(InriaSqliteHelper.CONTACT_TABLE, null, "where _id =  ? ", selection_values, null, null, null);
		if(cursor.moveToNext()){
			contact=new ContactModel();
			contact.setName(cursor.getString(cursor.getColumnIndex("name")));
			contact.setSex(ContactModel.toSex(cursor.getString(cursor.getColumnIndex("sex"))));
			contact.setCity(cursor.getString(cursor.getColumnIndex("city")));
			contact.setTeam(cursor.getString(cursor.getColumnIndex("team")));
			contact.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
			contact.setDetail(cursor.getString(cursor.getColumnIndex("detail")));
		}
		return contact;
	}
	
	//DRY, Don't Repeat Yourself !!!! Code to refactor
	public ArrayList<ContactModel> getAllContacts(){
		ArrayList<ContactModel> contacts = new ArrayList<ContactModel>();
		Cursor cursor=this.database.query(InriaSqliteHelper.CONTACT_TABLE, null, null, null, null, null, null);
		while(cursor.moveToNext()){
			//Have to create a contact object inside the while loop, because objects are passed by reference
			//if declared outside of the while loop, then every assignment will modify the same object in memory and adds it back to the array list
			ContactModel contact=new ContactModel();
			contact.setName(cursor.getString(cursor.getColumnIndex("name")));
			contact.setSex(ContactModel.toSex(cursor.getString(cursor.getColumnIndex("sex"))));
			contact.setCity(cursor.getString(cursor.getColumnIndex("city")));
			contact.setTeam(cursor.getString(cursor.getColumnIndex("team")));
			contact.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
			contact.setDetail(cursor.getString(cursor.getColumnIndex("detail")));
			contacts.add(contact);
		}
		return contacts;
	}
	
	//delete a contact via it's id
	//To be implemented by the participants
	public void deleteContact(int contact_id){
		
	}
	
	//delete a contact via a data model
	//To be implemented by the participants
	public void deleteContact(ContactModel contact){
		
	}
}
