package fr.inria.sampleapp;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class InriaSqliteHelper extends SQLiteOpenHelper {
	private final static String TAG="InriaSQliteHelper";
	public static final String DATABASE_NAME="inria_contact.db";
	
	public static final String CONTACT_TABLE="contact";
	private static final String CONTACT_SCHEMA="CREATE TABLE contact ("+
											  "_id integer primary key autoincrement,"+
											   "name VARCHAR(255) NULL DEFAULT NULL, " +
											   "sex VARCHAR(50) NULL DEFAULT NULL, "+
											   "city VARCHAR(255) NULL DEFAULT NULL, "+
											   "team VARCHAR(255) NULL DEFAULT NULL, "+
											   "phone VARCHAR(255) NULL DEFAULT NULL, "+
											   "detail TEXT NULL DEFAULT NULL"+
											   	");";
	
	public static final String _ID="_id";
	
	private static final int DB_VERSION=4;
	


	public InriaSqliteHelper(Context context){
		super(context, DATABASE_NAME, null, DB_VERSION);
	}
	
	

	@Override
	public void onCreate(SQLiteDatabase db) {
		Log.v(TAG, "Creating INRIA database table");
		db.execSQL(CONTACT_SCHEMA);
		// TODO Auto-generated method stub

	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		Log.v(TAG, "Upgrading database");
		// TODO Auto-generated method stub

	}

}
