package fr.inria.sampleapp;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import android.widget.TextView;

public class UserListLineView extends LinearLayout
{
	private TextView nameView;
	private TextView teamView;
	
	public UserListLineView(Context context)
	{
		super(context);
	}
	
	public UserListLineView(Context context, AttributeSet attributes)
	{
		super(context, attributes);
	}
	
	public UserListLineView(Context context, AttributeSet attributes, int defStyle)
	{
		super(context, attributes, defStyle);
	}
	
	@Override
	protected void onFinishInflate()
	{
		super.onFinishInflate();
		nameView = (TextView) findViewById(R.id.username);
		teamView = (TextView) findViewById(R.id.team);
	}

	public void update(String name, String team) 
	{
		nameView.setText(name);
		teamView.setText(team);
	}
}