package fr.inria.sampleapp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

import android.os.AsyncTask;
import android.util.JsonReader;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.Toast;

public class GenerateUserAsyncTask extends AsyncTask<Void, Void, ContactModel>
{
	private static String baseUrl = "http://api.randomuser.me/0.2";
	private UserActivity activity;	
	public GenerateUserAsyncTask(UserActivity activity)
	{
		this.activity = activity;
	}
	
	protected void onPreExecute()
	{
	}
	
	@Override
	protected ContactModel doInBackground(Void... params) 
	{
		return null;
	}

	@Override
	protected void onPostExecute(ContactModel user) 
	{
	}
	
	@Override
	protected void onCancelled(ContactModel user) 
	{
	}
	
	private Random random = new Random();
	private static String[] randomTeams = new String[] 
	{
		"ARLES",
		"GALLIUM",
		"SECRET",
		"HIPERCOM",
		"GANG",
		"PI.R2",
		"REGAL",
		"ARAMIS",
		"SISYPHE",
		"BANG",
		"ALPAGE"
	};
	
	private ContactModel parse(InputStream input)
	throws IOException
	{
		JsonReader reader = new JsonReader(new InputStreamReader(input, "UTF-8"));
		ContactModel user = new ContactModel();
		
		reader.beginObject();
		reader.nextName();
		reader.beginArray();
		while (reader.hasNext()) 
		{
			reader.beginObject();
			while (reader.hasNext()) 
			{
				String name = reader.nextName();
				if (name.equals("user"))
				{
					reader.beginObject();
					while (reader.hasNext()) 
					{
						name = reader.nextName();
						if (name.equals("gender"))
						{
							user.setSex(ContactModel.toSex(reader.nextString()));
						}
						else if (name.equals("name"))
						{
							reader.beginObject();
							String first = "";
							String last = "";
							while (reader.hasNext()) 
							{
								name = reader.nextName();
								if(name.equals("first"))
									first = uppercaseFirst(reader.nextString());
								else if(name.equals("last"))
									last = uppercaseFirst(reader.nextString());
								else
									reader.skipValue();
							}
							user.setName(first + " " + last);
							reader.endObject();
						}
						else if (name.equals("location"))
						{
							reader.beginObject();
							while (reader.hasNext()) 
							{
								name = reader.nextName();
								if(name.equals("city"))
									user.setCity(uppercaseFirst(reader.nextString()));
								else
									reader.skipValue();
							}
							reader.endObject();
						}
						else if (name.equals("phone"))
						{
							user.setPhone(reader.nextString());
						}
						else
							reader.skipValue();
					}
					
					reader.endObject();
				}
				else
					reader.skipValue();
			}
			reader.endObject();
		}
		reader.endArray();
		reader.endObject();
		
		reader.close();
		return user;
	}
	
	private String uppercaseFirst(String s)
	{
		return Character.toString(s.charAt(0)).toUpperCase() + s.substring(1);
	}
}
