package fr.inria.sampleapp;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.database.Cursor;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Toast;

/*
_id INT NULL AUTO_INCREMENT DEFAULT NULL,
name VARCHAR(255) NULL DEFAULT NULL,
sex VARCHAR(50) NULL DEFAULT NULL,
city VARCHAR(255) NULL DEFAULT NULL,
team VARCHAR(255) NULL DEFAULT NULL,
phone VARCHAR(255) NULL DEFAULT NULL,
detail MEDIUMTEXT NULL DEFAULT NULL,
*/

public class UserAdapter extends BaseAdapter
{
	private List<ContactModel> users = new ArrayList<ContactModel>();
	private final Context context;

	public UserAdapter(Context context)
 	{
		this.context = context;
	}
	
	public void updateUsers(List<ContactModel> users)
	{
		checkOnMainThread();
		
		this.users.clear();
		if(users != null)
			this.users.addAll(users);
		
		Toast.makeText(context, this.users.size() + " user(s) loaded", Toast.LENGTH_SHORT).show();
		notifyDataSetChanged();
	}
	
	public void updateUsers(Cursor cursor) 
	{
		checkOnMainThread();
		
		users.clear();
		if (cursor != null)
		{			
			int idIndex = cursor.getColumnIndex("_id");
			int nameIndex = cursor.getColumnIndex("name");
			int teamIndex = cursor.getColumnIndex("team");
			int sexIndex = cursor.getColumnIndex("sex");
			int cityIndex = cursor.getColumnIndex("city");
			int phoneIndex = cursor.getColumnIndex("phone");
			int detailIndex = cursor.getColumnIndex("details");
			while (cursor.moveToNext())
			{
				ContactModel user = new ContactModel
				(
					cursor.getString(nameIndex), 
					ContactModel.toSex(cursor.getString(sexIndex)), 
					cursor.getString(cityIndex), 
					cursor.getString(teamIndex), 
					cursor.getString(phoneIndex), 
					cursor.getString(detailIndex)
				);
				user.setId(cursor.getInt(idIndex));
				users.add(user);
			}
		}
		
		Toast.makeText(context, users.size() + " user(s) loaded", Toast.LENGTH_SHORT).show();
		notifyDataSetChanged();
	}

	@Override 
	public int getCount()
	{ 
		return users.size();
	} 
	@Override 
	public ContactModel getItem(int position)
	{ 
		return users.get(position);
	} 
	@Override 
	public long getItemId(int position)
	{ 
		return getItem(position).getId();
	} 
	@Override 
	public View getView(int position, View convertView, ViewGroup parent)
	{ 
		UserListLineView view;
		if (convertView == null)
			view = (UserListLineView)LayoutInflater.from(context).inflate(R.layout.userlist_item, parent, false);
		else
			view = (UserListLineView)convertView;
		
		ContactModel user = getItem(position);
		view.update(user.getName(), "(" + user.getTeam() + ")");
		return view;
	} 
	
	public void checkOnMainThread()
	{
		if(Thread.currentThread() != Looper.getMainLooper().getThread())
			throw new IllegalStateException("Wrong thread");
	}
} 
