package fr.inria.sampleapp;


import android.app.Activity;
import android.app.LoaderManager;
import android.content.CursorLoader;
import android.content.Intent;
import android.content.Loader;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;

public class MainActivity extends Activity implements OnItemClickListener/*, LoaderManager.LoaderCallbacks<Cursor>*/ 
{
	private UserAdapter userListAdapter;
	private ContactDataSource dataSource;
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		//getLoaderManager().initLoader(1, null, this);
	}
	
	@Override
	protected void onResume()
	{
		super.onResume();
		
		userListAdapter = new UserAdapter(this);
		ListView listView = (ListView) findViewById(R.id.userList);
		listView.setAdapter(userListAdapter);
		listView.setOnItemClickListener(this);
		
		dataSource = new ContactDataSource(this);
		dataSource.openDatabase();
		userListAdapter.updateUsers(dataSource.getAllContacts());
		dataSource.closeDatabase();
	}
	
	@Override
	public void onItemClick(AdapterView<?> parent, View v, int position, long id)
	{
		ContactModel user = userListAdapter.getItem(position);
		Intent intent = new Intent(this, UserActivity.class);
		intent.putExtra("user", user);
		startActivity(intent);
	}
	
	/*@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args)
	{ 
		return new CursorLoader(this, Uri.parse("content://fr.inria.myProvider/data"), null, null, null, "name");
	} 

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor data)
	{
		userListAdapter.updateUsers(data);
	} 

	@Override
	public void onLoaderReset(Loader<Cursor> loader)
	{ 
		userListAdapter.updateUsers((Cursor)null);
	}*/
	
	public void createUserButtonPressed(View v)
	{
		Intent intent = new Intent(this, UserActivity.class);
		startActivity(intent);
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.main, menu);		
		return true;
	}
}
