package fr.inria.sampleapp;

import java.io.Serializable;

public class ContactModel implements Serializable
{
	private static final long serialVersionUID = -3715319333674464182L;
	
	private int id = -1;
	private String name;
	private Sex sex;
	private String team;
	private String city;
	private String detail;
	private String phone;	
	
	public ContactModel()
	{
	}
	
	public ContactModel(String name)
	{
		this.name = name;
	}

	public ContactModel(String name, Sex sex, String city, String team, String phone)
	{
		this.name = name;
		this.sex = sex;
		this.city = city;
		this.team = team;
		this.phone = phone;
	}
	
	public ContactModel(String name, Sex sex, String city, String team, String phone, String detail)
	{
		this(name, sex, city, team, phone);
		this.detail = detail;
	}
	
	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Sex getSex()
	{
		return sex;
	}

	public void setSex(Sex sex)
	{
		this.sex = sex;
	}

	public String getTeam()
	{
		return team;
	}

	public void setTeam(String team)
	{
		this.team = team;
	}

	public String getCity()
	{
		return city;
	}

	public void setCity(String city)
	{
		this.city = city;
	}

	public String getDetail()
	{
		return detail;
	}

	public void setDetail(String detail)
	{
		this.detail = detail;
	}

	public String getPhone()
	{
		return phone;
	}

	public void setPhone(String phone)
	{
		this.phone = phone;
	}
	
	protected int getId()
	{
		return id;
	}

	protected void setId(int id)
	{
		this.id = id;
	}

	@Override
	public String toString()
	{
		return name + ";" + sex + ";" + city + ";" + team + ";" + phone + ";" + detail;
	}

	public static enum Sex
	{
		Male,
		Female,
		Unspecified
	}

	public static Sex toSex(String sex)
	{
		sex = sex.toLowerCase().trim();
		if("male".equals(sex) || "homme".equals(sex))
			return Sex.Male;
		else if("female".equals(sex) || "femme".equals(sex))
			return Sex.Female;
		else
			return Sex.Unspecified;
	}
}
