package fr.inria.sampleapp;

import fr.inria.sampleapp.ContactModel.Sex;
import android.os.AsyncTask.Status;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.view.Menu;
import android.view.View;
import android.widget.EditText;
import android.widget.RadioGroup;

public class UserActivity extends Activity
{	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_user);
		
		Intent intent = getIntent();
		if(intent.hasExtra("user"))
		{
			ContactModel user = (ContactModel) intent.getExtras().getSerializable("user");
			if(user != null)
				fillUIWithUser(user);
		}
	}
	
	@Override
	protected void onPause()
	{
		super.onPause();
	}
	
	public void generateButtonPressed(View v)
	{
	}
	
	public void saveButtonPressed(View v)
	{
		ContactDataSource dataSource = new ContactDataSource(this);
		ContactModel user = getUser();
		dataSource.openDatabase();
		dataSource.addContact(user);
		dataSource.closeDatabase();		
		finish();
	}
	
	public void fillUIWithUser(ContactModel user)
	{		
		EditText text = (EditText)findViewById(R.id.username);
		text.setText(user.getName());
		
		text = (EditText)findViewById(R.id.city);
		text.setText(user.getCity());
		
		text = (EditText)findViewById(R.id.team);
		text.setText(user.getTeam());
		
		text = (EditText)findViewById(R.id.phone);
		text.setText(user.getPhone());
		
		text = (EditText)findViewById(R.id.details);
		text.setText(user.getDetail());
		
		RadioGroup radio = (RadioGroup)findViewById(R.id.gender);
		switch(user.getSex())
		{
			case Male:
				radio.check(R.id.gender_male);
				break;
			case Female:
				radio.check(R.id.gender_female);
				break;
			case Unspecified:
				radio.check(R.id.gender_unspecified);
				break;
		}
	}
	
	public ContactModel getUser()
	{
		ContactModel user = new ContactModel();
		
		EditText text = (EditText)findViewById(R.id.username);
		user.setName(text.getText().toString());
		
		text = (EditText)findViewById(R.id.city);
		user.setCity(text.getText().toString());
		
		text = (EditText)findViewById(R.id.team);
		user.setTeam(text.getText().toString());
		
		text = (EditText)findViewById(R.id.phone);
		user.setPhone(text.getText().toString());
		
		text = (EditText)findViewById(R.id.details);
		user.setDetail(text.getText().toString());
		
		RadioGroup radio = (RadioGroup)findViewById(R.id.gender);
		switch(radio.getCheckedRadioButtonId())
		{
			case R.id.gender_male:
				user.setSex(Sex.Male);
				break;
			case R.id.gender_female:
				user.setSex(Sex.Female);
				break;
			default:
				user.setSex(Sex.Unspecified);
		}
		
		return user;
	}
	

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
}
