# ************************ #
# Mardi 19 dc. 2017
# SCRIPT 2 - DIFFERENTS TYPES OBJETS
# ************************ #

rm(list=ls())
dossier <- 'C:/Users/mintsa/Desktop/ARAMIS/Scripts_Presentation'
setwd(dossier)
getwd()
dir()


# ************************ #
# PREMIERS OBJETS 
# ************************ #

# 1. vecteur : numerique , booleen , caractere
# ---------------------------------------------------------------------------
v0 <- c('lundi','mardi','mercredi','')     # c pour concatenation
v0

v1 <- c(1 , -5 , 3^2 , 2.67 , pi , exp(1) , log(2,base = exp(1)) , sqrt(2) , 0.89*10)
v1
v2 <- seq(from = 0 , to = 1 , by = 0.2)    # seq pour sequence
v2
v3 <- 4:10
v3

v4 <- rep(NA , times = 4)          # rep pour repeat
v4
v5 <- v1 < 2                       # vecteur booleen : TRUE si la condition est vraie, FALSE sinon
v5


# 2. matrice
# ---------------------------------------------------------------------------
m1 <- matrix(v2 , nrow = 4 , ncol = 3 , byrow = TRUE)
m1
m2 <- rbind(v4,v1) # row bind : attacher en ligne (la premiere ligne est completee en boucle)
m2
# Attention : en utilisant la concatenation "c()", 
# on place les elements l'un a la suite de l'autre pour constituer un vecteur
c(v4,v1)
m3 <- cbind(v2,v5) # column bind : attacher en colonne
m3
# R rale un peu a cause des dimensions : Warning message
# mais il execute la commande en completant la colonne 1 avec les premiers elements de v2
# A noter : matrice numerique, donc FALSE est converti en valeur 0 ; TRUE, en valeur 1

# 3. dimension des objets
# ---------------------------------------------------------------------------
length(m1)
dim(m1)
nrow(m1)
ncol(m1)
View(m1)


# 4. acceder aux elements de ces objets
# ---------------------------------------------------------------------------
# vecteurs : 1 seule dimension
v5[4]
v1[1:3]
# matrices : 2 dimensions
m1[,2]          # deuxieme colonne
m1[1,]          # premiere ligne
m1[4,2]         # un element specifique , une cellule
m1[c(1,4),]

# 5. valeur NA
# ---------------------------------------------------------------------------
is.na(m2)
is.na(v0)
v0 == ''


# 6. Exemple de donnees contenues dans les packages
# ---------------------------------------------------------------------------
data()

# dans tous les packages disponibles
# data(package = .packages(all.available = TRUE))

# dans un package spcifique
# data(package = 'ade4')
# ---------------------------------------------------------------------------
# ---------------------------------------------------------------------------




# ************************ #
# OBJETS PLUS ELABORES
# ************************ #

# Time Series : pour creer sa propre serie temporelle --> ts()
# ---------------------------------------------------------------------------
data(LakeHuron)
LakeHuron
str(LakeHuron) # la structure de l'objet
help(LakeHuron)
attributes(LakeHuron) # les attributs d'un objet


# Liste
# ---------------------------------------------------------------------------
data(ability.cov)
ability.cov 
help(ability.cov)
str(ability.cov)

ability.cov[[3]]
ability.cov$n.obs
# liste des attributs associes a cet objet
attributes(ability.cov)
names(ability.cov)
dimnames(ability.cov)     # renvoie NULL car cet attribut n'existe pas pour cet objet


# Remarque : les "list" permettent de construire des objets avec des contenus de nature differente
jdd <- list(var1 = rep(-1,5) , var2 = matrix(1:8,nrow=4,ncol=2),
            var3 = list(x=NA,y=0,z='aramis') , var4 = c('lu','ma','me','je'),
            var5 = ts(ability.cov$cov[,'picture'],frequency=4))
jdd[[1]]    # acceder au premier element de la liste
jdd[['var5']]
jdd$var2
jdd$var2[3,]
jdd
jdd$var3$z
str(jdd[[3]])


# Names num (vecteurs nommes)
# ---------------------------------------------------------------------------
data(islands)
islands
help(islands)
str(islands)

# fonctions sur les chaines de caracteres
nom <- names(islands)[seq(1,length(islands),6)]

charmatch(nom,'Banks',nomatch=0) 
charmatch(nom,'an',nomatch=0) 
grep('an',nom,ignore.case=TRUE)            # trouver une expression
sub('of','XX',nom,ignore.case=TRUE)        # remplacer
substr(nom,2,4)                            # extraire une partie d'une chaine
tolower(nom)
toupper(nom)


# Class dist
# ---------------------------------------------------------------------------
data(eurodist)
eurodist
str(eurodist)


# Class table
# ---------------------------------------------------------------------------
data(HairEyeColor)
HairEyeColor
help(HairEyeColor)
str(HairEyeColor)

# table de contingence avec le croisement de 3 variables
dimnames(HairEyeColor)
ref1 <- 4
ref2 <- 3
ref3 <- 1
# nom des modalites
dimnames(HairEyeColor)$Hair[ref1]
dimnames(HairEyeColor)$Eye[ref2]
dimnames(HairEyeColor)$Sex[ref3]
HairEyeColor[ref1,ref2,ref3]          # effectif pour le croisement de ces trois modalites

# nombre de croisements possibles
length(HairEyeColor)
# nombre d'individus
sum(HairEyeColor)

# nombre de Male
sum(HairEyeColor[,,'Male'])
# nombre de Hair Brown
sum(HairEyeColor['Brown',,])

# nombre de Eye Green pour Female
sum(HairEyeColor[,'Green','Female'])

# isoler les effectifs sur les Female
jdd <- HairEyeColor[,,'Female']
str(jdd)
jdd
# sommer en ligne (margin = 2 pour colonne)
margin.table(jdd,margin=1)


rm(list = ls())
# ---------------------------------------------------------------------------
# ---------------------------------------------------------------------------


# ************************ #
# FONCTIONS BASIQUES
# ************************ #

vector() 
sort()
order()
rev()

sum()
range()
min()
max()
mean()
sd()
var()
cor()
covar()
# ---------------------------------------------------------------------------
# ---------------------------------------------------------------------------


# ************************ #
# CALCUL MATRICIEL
# ************************ #
# https://fr.wikibooks.org/wiki/Programmer_en_R/Manipuler_les_matrices
# multiplication de matrices
# ---------------------------------------------------------------------------
mat1 <- matrix(1:10,ncol=2)
mat2 <- matrix(rep(10,6),nrow=2)
mat1%*%mat2

# matrice carre
# ---------------------------------------------------------------------------
mat3 <- matrix(-4:4,nrow=3)
diag(mat3)
upper.tri(mat3 , diag = TRUE)
lower.tri(mat3 , diag = FALSE)
 
mat3[2,2]<-10 
solve(mat3)

# ---------------------------------------------------------------------------
# ---------------------------------------------------------------------------

