# ************************ #
# Mardi 19 dc. 2017
# SCRIPT 3 - DATA FRAME
# ************************ #

# type data.frame = type specifique dedie a la manipulation d'un jeu de donnees
# presentant m variables (numeriques, categorielles, caracteres) (== colonnes )
# pour n individus (== lignes)

# ******************** #
# LES PREMIERES LIGNES
# ******************** #
# vider l'espace de travail
rm(list=ls())
# enregistrer le script : CRTL S
# effacer la console : la rendre active et taper CTRL L

# enregistrer le chemin du dossier de travail
dossier <- 'C:/Users/mintsa/Desktop/Atelier ARAMIS/Scripts_Presentation'
# ATTENTION : remplacer les \ par des /
# fixer le Work Directory
setwd(dossier)

# verifier 
getwd()

# lister le contenu du dossier
dir()


# ******************************************************** #
# UN EXEMPLE A PARTIR D'UN JEU DE DONNEES DISPONIBLE DANS R
# ******************************************************** #


# ---------------------------------------------------------------------------
# 1. contenu de R data sets : un exemple de data.frame
# ---------------------------------------------------------------------------
data()            # un nouvel onglet s'affiche R data sets
data(airquality)
# Daily air quality measurements in New York, May to September 1973.
airquality
help(airquality)    # obtenir un descriptif des donnees
str(airquality)     # structure du data.frame : 153 observations , 6 variables
mode(airquality)    # un data.frame est considere comme une liste
length(airquality)  # 6 elements dans la liste, 1 element est une variable

donnees <- airquality

# redefinir la variable Month en variable categorielle
donnees$Month <- as.factor(donnees$Month)
str(donnees)


# ---------------------------------------------------------------------------
# 2. les attributs sont directement accessibles avec le nom de la fonction
# ---------------------------------------------------------------------------
attributes(donnees)
names(donnees)
row.names(donnees)
class(donnees)
# renvoie NULL pour un attribut non declare


# ---------------------------------------------------------------------------
# 3. contenu de l'objet : dimensions , elements
# ---------------------------------------------------------------------------
dim(donnees)
nrow(donnees)
ncol(donnees)

dimnames(donnees)    # nom des differentes dimensions : lignes et colonnes
rownames(donnees)    # ou row.names
colnames(donnees)    # col.names n'existe pas
labels(donnees)      # idem dimnames()

# renommer les individus
rownames(donnees) <- paste('indiv',row.names(donnees),sep='_')


head(donnees , n=3)  # les n premieres lignes du jeu de donnees
tail(donnees , n=5)  # les n dernieres lignes du jeu de donnees
View(donnees)        # afficher le jeu de donnee dans un autre onglet (sous forme de  tableau)
donnees              # afficher le jeu de donnees dans la console
print(donnees)


# ---------------------------------------------------------------------------
# 4. resume statistique global
# ---------------------------------------------------------------------------
summary(donnees) 
# indicateurs stats pour les variables numeriques
# tableau d'effectif pour les variables categorielles (ie. pour factor)


# ---------------------------------------------------------------------------
# 5. acceder au contenu du jeu de donnees
# ---------------------------------------------------------------------------
# 4 manieres d'acceder a la colonne 2 = variable Solar.R 
v1 <- donnees$Solar.R           # faire reference au nom de la variable
v2 <- donnees[,'Solar.R']
v3 <- donnees[,2]            # deux dimensions : [ref ligne , ref colonne]
v4 <- donnees[[2]]           # [[]] car l'objet est egalement percu comme une liste

# les individus
donnees[4,]                  # le 4 eme individu
donnees[c(4,23,68),]         # une liste d'individus
donnees[seq(from = 1 , to = nrow(chickwts) , by = 11),]         # liste d'individus, toutes les 11 lignes
donnees[seq(from = 1 , to = nrow(chickwts) , length.out = 4),]  # liste d'individus, nombre fixe

# une cellule
donnees[4,1]
donnees[4,'Ozone']
donnees["indiv_4",'Ozone']    # car rownames = 'indiv_1' , 'indiv_2', 'indiv_3' , etc.
donnees["indiv_4",1] 


rm(v1,v2,v3,v4)


# ---------------------------------------------------------------------------
# 6. Selon le type de variable
# ---------------------------------------------------------------------------
# variable numerique : indicateurs statistiques et operations
class(donnees$Wind)
typeof(donnees$Wind)

class(donnees$Ozone)
mode(donnees$Ozone)

quantile(donnees$Ozone , probs = c(0,0.10,0.25,0.5,0.75,0.9,1) , na.rm=TRUE)

is.na(donnees$Ozone)       # renvoie un booleen qui repond a la question
sum(is.na(donnees$Ozone))  # nombre de valeurs manquantes (pour la somme, TRUE == 1 , FALSE == 0)
summary(donnees$Ozone)


# calcul : Temperature en degres Celsius  : T(F) = 1,8 T(C) + 32
# operations : + ; - ; * ; / ; ^ ou ** ; %% = modulo ; %/% = division entiere
(donnees$Temp - 32)/1.8

# ajouter cette variable dans le jeu de donnees (creer un nouvel objet)
donnees0 <- cbind(donnees,(donnees$Temp - 32)/1.8)
str(donnees0)
donnees0 <- data.frame(donnees,(donnees$Temp - 32)/1.8)
str(donnees0)

# ajout de variables, version 3
res <- within(donnees, {WindExp <- exp(Wind) 
                OzoneBool <- Ozone<20
                TempCelsius <- (Temp - 32)/1.8
                rm(Solar.R)})
# il faut forcement aller a la ligne pour chaque instruction
str(res)
head(res)
rm(res)

# renommer la troisieme colonne
donnees <- data.frame(donnees,(donnees$Temp - 32)/1.8)
names(donnees)[ncol(donnees)] <- 'TempCelsius'


# variable categorielle (i.e. factor) : liste des modalites
levels(donnees$Month)
unique(donnees$Month)
nlevels(donnees$Month)
table(donnees$Month)         # nombre d'observations pour chaque modalite
summary(donnees$Month)

# pour ne pas garder des levels de factor qui n'ont plus d'observations : variable <- factor(variable, exclude = NULL)
jdd <- donnees[1:50,]
table(jdd$Month)
levels(jdd$Month)
jdd$Month <- factor(jdd$Month , exclude = NULL)
table(jdd$Month)
levels(jdd$Month)


# ATTENTION sur le changement de type de variable  partir d'un factor
jdd$Month
as.numeric(jdd$Month) # renvoie le rang du level
as.numeric(as.character(jdd$Month))


# unicite des valeurs
round(donnees$Wind,0)
unique(round(donnees$Wind,0))
duplicated(round(donnees$Wind,0))
# nombre d'occurences pour chaque valeur unique
table(round(donnees$Wind,0))


# autres fonctions pour arrondir des nombres reels
floor(donnees$Wind)
ceiling(donnees$Wind)



# ---------------------------------------------------
# 7. fonction attach() 
# ---------------------------------------------------
# cette fonction permet de ne pas manipuler le data.frame avec le $ (contraire : detach())
# la variable de l'objet est alors accessible directement
Wind # R ne connait pas cet objet
attach(donnees)
Wind # R sait que l'objet est rattache a donnees
detach()
Wind



# ---------------------------------------------------
# 8. ajouter un individu
# ---------------------------------------------------
jdd <- donnees[,c('Ozone','Month')]
jdd <- rbind(jdd,c(20,'3'),c(20,'6'))
str(jdd)
tail(jdd)
# sauf que R ne reconnait pas un vecteur qui melange des valeurs numeriques avec du caractere
# il a donc transforme 20 en '20' et la variable Ozone dans jdd est devenue de type chr

indiv <- data.frame(rbind(c(20,3),c(20,6)))
str(indiv)
names(indiv) <- names(jdd)
indiv$Month <- as.factor(indiv$Month)

jdd <- donnees[,c('Ozone','Month')]
jdd <- rbind(jdd,indiv)
str(jdd)
tail(jdd)

# autrement
jdd <- rbind(donnees[,c('Ozone','Month')],donnees[1,c('Ozone','Month')])
jdd[nrow(jdd),1] <- 20
jdd[nrow(jdd),2] <- '3'
str(jdd)
tail(jdd)
# le factor 3 n'est pas accepte ---> convertir en charactere avant de repasser en factor
jdd <- rbind(donnees[,c('Ozone','Month')],donnees[1,c('Ozone','Month')])
jdd$Month <- as.character(jdd$Month)
jdd[nrow(jdd),1] <- 20
jdd[nrow(jdd),2] <- '3'
str(jdd)
tail(jdd)
jdd$Month <- as.factor(jdd$Month)
str(jdd)




rm(donnees0,jdd,indiv)


# ---------------------------------------------------
# 9. sous-ensemble
# ---------------------------------------------------
# les releves les jours du mois de mai ou avec temperature > 30C
# garder uniquement les variables Ozone, Wind et Solar.R
# fonction subset()
dat <- subset(x = donnees , Month == '5' | TempCelsius>30  , select = c('Ozone','Wind','Solar.R'))
str(dat)

# selection booleene : garder les lignes qui satisfont la condition
dat <- donnees[donnees$Month == '5' | donnees$TempCelsius>30, ]
str(dat)


# fonction which() - cf. paragraphe 10.
dat <- donnees[which(donnees$Month == '5' | donnees$TempCelsius>30),]
str(dat)

# transformations sur les colonnes : booleen
with(donnees, Ozone<20)
donnees$Ozone < 20

with(donnees, Ozone<20 & Month=='5')



# split()  -> en sortie, objet list , parametre f : doit etre de type factor
dat <- split(donnees[,1:3] , f = donnees$Month)
str(dat)
# supprimer ou non les modalites qui n'apparaissent pas dans le jeu de donnees
dat <- split(donnees[1:50,] , f = donnees$Month[1:50] , drop=TRUE)
str(dat)
dat <- split(donnees[1:50,] , f = donnees$Month[1:50] , drop=FALSE)
str(dat)
dat[[1]]$Ozone
dat[[1]][,1]

rm(dat)


# ----------------------------------------------------------------------------------
# 10. Fonction which() : poser des conditions, resoudre des equations, inequations
# ----------------------------------------------------------------------------------
# Cette fonction renvoie le numero de ligne
# les operateurs utilises : != ; == ; < ; > ; <= ; >= ; ET : & ; OU : | (Alt GR 6) ; %in%

qui <- which(donnees$Ozone > 80) # vecteur de taille 16 car seulement 16 jours satisfont la condition
qui
cat(paste('\n nombre de journees avec taux d\'Ozone > 80 ppb : ',length(qui),sep=''))

qui <- donnees$Ozone > 80 # vecteur booleen de taille 153
qui
which(qui==TRUE)      # pour recuperer les lignes
cat(paste('\n nombre de journees avec taux d\'Ozone > 80 ppb : ',sum(qui,na.rm=TRUE),sep='')) # TRUE vaut 1, FALSE vaut 0


# quelle vitesse du vent pour ces 16 journees ?
qui <- which(donnees$Ozone > 80)
donnees[qui,]
donnees$Wind[qui]
donnees[qui,'Wind']

# dans un ensemble
val <- c(34,80,20,40,14)
z <- which(donnees$Ozone %in% val)
donnees$Ozone[z]


# si on fait un attach(donnees) : Wind[qui]

# repartition selon les modalites de Month
table(donnees[qui,'Month'])
prop.table(table(donnees[qui,'Month']))  # prop.table s'applique a un objet de type table


# double condition
qui <- which(donnees$Ozone>100 & donnees$TempCelsius>25)
donnees[qui,]


rm(qui,val,z)

# ---------------------------------------------------
# 11. vectorialiser
# ---------------------------------------------------
# calculer la moyenne pour toutes les variables numeriques du jeu de donnees
# version boucle
kount <- 0
val <- NA
for (ref in 1:ncol(donnees))
{
  cat(paste('\n class de la variable : ',names(donnees)[ref],' : ',class(donnees[,ref]),sep=''))
  if (class(donnees[,ref]) == 'numeric' | class(donnees[,ref]) == 'integer' )
  {
    kount <- kount + 1
    val[kount] <- mean(donnees[,ref],na.rm=TRUE)
  }
}
val

# fonctions apply() and co
# Returns a vector or array or list of values obtained by 
# applying a function to margins of an array or matrix.
# MARGIN = 1 equals rows ; MARGIN = 2 equals columns

# isoler les variables numeriques
colonne <- 1:ncol(donnees)  
colonne <- colonne[-5]

res1 <- apply(X = donnees[,colonne] , MARGIN = 2 , FUN = mean , na.rm = TRUE)       # en sortie objet de type names vector
str(res1)
res1
res2 <- lapply(X = donnees[,colonne] , MARGIN = 2 , FUN = mean , na.rm = TRUE)      # en sortie objet de type list
str(res2)
res2


# obtenir la moyenne pour chaque modalite d'un factor
res3 <- tapply(X = donnees$Ozone , INDEX = donnees$Month , simplify = FALSE , FUN = mean , na.rm = TRUE) 
# avec simpify = TRUE --> objet de type vector
str(res3)
res3
# limite : traite une seule variable

# pour traiter toutes les variables en meme temps
# aggregate : Splits the data into subsets, 
# computes summary statistics for each, and returns the result in a convenient form.
# by : de type list
res4 <- aggregate(x = donnees[,colonne] , by = list(donnees$Month) , simplify = FALSE , FUN = mean , na.rm = TRUE) 
str(res4)
res4

# en combinant deux variables categorielles
summary(donnees$Wind)
# categoriser la variable Wind
cut(donnees$Wind, breaks=quantile(donnees$Wind, c(0, 0.25, 0.5, 0.75, 1)), include.lowest = TRUE)
cut(donnees$Wind, breaks=c(1,8,15,21), include.lowest = TRUE)
WindFactor <- cut(donnees$Wind, breaks=c(1,8,15,21), include.lowest = TRUE)
# pour les valeurs qui depassent la limite maximale proposee par breaks, la fonction retourne des NA
cut(donnees$Wind, breaks=c(1,8,15),include.lowest = TRUE , right = TRUE)
cut(donnees$Wind, breaks=c(1,8,15),include.lowest = TRUE , right = FALSE)
cut(donnees$Wind, breaks=c(1,8,15),include.lowest = FALSE , right = TRUE)
cut(donnees$Wind, breaks=c(1,8,15),include.lowest = FALSE , right = FALSE)



donnees <- data.frame(donnees,WindFactor)
str(donnees)

aggregate(x = donnees[,colonne] , by = list(donnees$WindFactor) , simplify = FALSE , FUN = mean , na.rm = TRUE) 
aggregate(x = donnees[,colonne] , by = list(donnees$Month,donnees$WindFactor) , simplify = FALSE , FUN = mean , na.rm = TRUE) 

# effectifs dans chaque groupe
table(donnees$Month,donnees$WindFactor)
addmargins(table(donnees$Month,donnees$WindFactor),FUN = sum)
addmargins(table(donnees$Month,donnees$WindFactor),FUN = min)
addmargins(table(donnees$Month,donnees$WindFactor),FUN = max)
addmargins(table(donnees$Month,donnees$WindFactor),FUN = median)


rm(res1,res2,res3,res4,val,WindFactor,kount,ref)



# ---------------------------------------------------
# 12. graphiques
# ---------------------------------------------------

# graphiques statistiques
pie(table(donnees$WindFactor))      # diagramme circulaire
barplot(table(donnees$WindFactor))
boxplot(donnees[,'Wind'])           # boite a moustache
boxplot(donnees[,colonne] , las = 2) # las = 2 : afficher le nom des variables perpendiculairement a l'axe

#avec la formula 
boxplot(donnees$Wind ~ donnees$Month)

# histogramme pour variable continue
summary(donnees$Wind)
hist(donnees$Wind , freq = TRUE , breaks = seq(0,24,6) , 
     xlab = 'titre X' , ylab = 'titre Y' , main = 'titre Graph' , col = 4) # effectifs

hist(donnees$Wind , freq = FALSE , breaks = seq(0,24,3) , col=8) # frequence
# superposition d'une fonction de densite
# le x est generique  : 
# R travaille avec les abscisses definies par la fonction de premier niveau (ici, hist)
curve(dnorm(x,mean = mean(donnees$Wind) , sd = sd(donnees$Wind)) , col='deeppink3' , add=TRUE , lwd = 2 , lty = 5) 

# NUAGE DE POINTS  : representer y en fonction de x - plot (x,y) ou plot(y ~ x)
# formula y ~ x
# le niveau d'Ozone peut-il etre explique par la temperature?
cor(donnees$Ozone , donnees$TempCelsius , use = "complete.obs")
plot(donnees$TempCelsius , donnees$Ozone, col='navy' , pch = 18)


# plus complet
# avec la formula
plot(donnees$Ozone ~ donnees$TempCelsius, col='navy' , pch = 'x')

# des fonctions de deuxieme niveau (viennent se superposer sur un graphique existant)
points(mean(donnees$TempCelsius,na.rm=TRUE) , mean(donnees$Ozone,na.rm=TRUE) , pch=16 , col='firebrick3' , cex = 2)
# tracer la droite de regression lineaire
# fontion lm() pour linear model
abline(lm(donnees$Ozone ~ donnees$TempCelsius ) , col='forestgreen' , lwd = 2 , lty = 2)

# ajouter le centre de gravite == point moyen
points(mean(donnees$TempCelsius,na.rm=TRUE) , mean(donnees$Ozone,na.rm=TRUE) , pch=16 , col='firebrick3' , cex = 2)

# coller la valeur du coefficient de correlation lineaire
k <- cor(donnees$TempCelsius , donnees$Ozone , use = 'complete.obs')
text(60 , 110 , cex = 0.8 , labels = paste('coeff cor = ',round(k,3)) , col='chocolate4' , adj = 0)

# mettre une legende
legend('topleft' , legend=c('nuage de points','droite regression','centre gravite') , 
       col=c('navy','forestgreen','firebrick3'),
       pch = c(4,NA,16) , lty=c(NA,2,NA) , lwd = c(1,2,2) , cex = 0.7)

# utiliser la fonction title pour formater les labels
title(main = 'Niveau d\'ozone en fonction de la temperature \n Donnees de New York 1973' , 
      sub = "Sous-titre",
      cex.main = 0.9, font.main= 4, col.main= "violetred3",
      cex.sub = 1.2, font.sub = 3, col.sub = "magenta4")


# d'autres fonctions de deuxieme niveau
# lines , arrows , segments , polygon
	  

# ---------------------------------------------------
# 13. FORMULA
# ---------------------------------------------------

# Y en fonction de X
lm(donnees$Ozone ~ donnees$Wind)
# Y en fonction de X1 et x2
lm(donnees$Ozone ~ donnees$Wind + donnees$Temp)
# Y en fonction de cste
lm(donnees$Ozone ~ 1)
# Y en fonction de toutes les variables quantitatives disponibles
lm(donnees$Ozone ~ . , data=donnees[,1:4])





