# ************************ #
# Mardi 19 dc. 2017
# SCRIPT 2 - FONCTIONS DE BASE
# ************************ #

rm(list=ls())
dossier <- 'C:/Users/mintsa/Desktop/ARAMIS/Scripts_Presentation'
setwd(dossier)
getwd()
dir()

# ************************ #
# STRUCTURE ET DIMENSIONS
# ************************ #
v1 <- c(1 , -5 , 3^2 , 2.67 , pi , exp(1) , log(2,base = exp(1)) , sqrt(2) , 0.89*10)
v1
m1 <- matrix(v1,nrow=4)
m1
# possible pour tous types d'objets
str(m1)
length(m1)
mode(m1)
str(v1)
length(v1)
mode(v1)

dim(v1)       # renvoie NULL car un vecteur a une seule dimension
dim(m1)
nrow(m1)
ncol(m1)
View(m1)      # afficher l'objet dans un tableur : nouvel onglet
View(v1)

typeof(v1)
typeof(m1)


# on peut changer la nature de l'objet
v2 <- as.integer(v1)
v2
typeof(v2)

v3 <- as.character(v1)
v3
typeof(v3)

v4 <- as.factor(v2)  # variable catagorielle ou on fixe les modalites possibles (appelees levels)
v4
typeof(v4)
nlevels(v4)
levels(v4)


rm(v4,v3,v2,v1,m1)



# ************************ #
# TRI
# ************************ #
vect <- c(2 , -7 , 4 , 0.5 , 6 , 0 , 2.5)
vect
rev(vect)                           # renverse l'ordre du vecteur initial
sort(vect , decreasing = TRUE)      # range les valeurs et les renvoie triees
order(vect , decreasing = TRUE)     # range les valeurs et renvoie les indices




# ************************ #
# INDICATEURS STATISTIQUES
# ************************ #
sum(vect)

min(vect)
max(vect)
range(vect)

mean(vect)
v0 <- c(vect,NA)
mean(v0)           # attention en presence de valeurs manquantes
mean(v0 , na.rm=TRUE)
sd(vect)     
var(vect)          # attention : variance corrigee i.e. estimateur non biaise (division par n-1 et non pas n)
cor(vect,vect-3)   # coefficient de correlation lineaire (sens de Pearson) , parametre method pour changer le type de coefficient

# quantiles et median : 50% des valeurs inferieurs a 0.25 ; 50% superieur a 0.25
median(vect)
quantile(vect , probs = c(0.25, 0.3 , 0.75 , 1))
IQR(vect)          # Q3 - Q1


# ************************ #
# MANIPULATION D'ENSEMBLES
# ************************ #
is.element(0,vect)
10 %in% vect

is.na(v0)
vect
vect-2
# dans setdiff, l'ordre joue un role
setdiff(vect,vect-2)
setdiff(vect-2,vect)
intersect(vect,vect-2)
setequal(vect,vect-2)    # egalite terme a terme
union(vect,vect-2)       # sans repetition
v1 <- abs(as.integer(c(vect,vect-2)))
v1
unique(v1)
duplicated(v1)
table(v1)                # nombre d'occurrences de chaque valeur


# ************************ #
# CHAINES DE CARACTERES
# ************************ #

nom <- strsplit(dossier,'/')
nom[[1]]
nom[[1]][4]

nom <- unlist(nom)  # travailler avec un vecteur de caracteres et non une liste

charmatch(nom,'A',nomatch=0) 
charmatch(nom,'ARAMIS',nomatch=0) 
charmatch(nom,'aramis',nomatch=0) 
charmatch(nom,nom[2],nomatch=0) 

grep('mi',nom,ignore.case=TRUE)            # trouver une expression
sub('mi','XX',nom,ignore.case=TRUE)        # remplacer
substr(nom,2,4)                            # extraire une partie d'une chaine
tolower(nom)
toupper(nom)




# ************************ #
# EQUATIONS
# ************************ #

# solveur
matA <- matrix(vect[1:4] , nrow=2 , ncol=2 , byrow=FALSE)
matB <- matrix(c(-1,1),nrow=2,ncol=1)
solve(matA)               # calcul de l'inverse
solve(matA,matB)          # eq. matA * X = matB

matC <- solve(matA,matB)
matA %*% matC             # produit matriciel
matA%*%matB 
matA*cbind(matB,matB)     # produit terme a terme (avoir les memes dimensions)
matA*matB
eigen(matA)               # valeurs propres et vecteurs propres

# which()
vect <- c(matA,matB)
vect
which(vect<0)           # renvoie les index des valeurs qui satisfont la condition
newvect <- vect<0       # construit un vecteur booleen
newvect

# symboles : & = ET   ;   | = OU   ;   == , < , > , <= , >=
which(abs(vect) == 1)   # fonction abs() : renvoie la valeur absolue
which(abs(vect) == 1 | abs(vect) == 2)

which.min(vect)
which.max(vect)


# ************************ #
# LOIS DE PROBABILITES
# ************************ #

# loi normale
# generation de nombre aleatoire
# 10 valeurs issues d'une population gaussienne de moyenne 0 et d'ecart-type 1
rnorm(n = 10 , mean = 0 , sd = 1)
# fixer la racine de l'algo de generation des nombres aleatoires pour dupliquer le meme resultat
set.seed(100)
rnorm(n = 10 , mean = 0 , sd = 1)

# probabilite de realisation de l'evenement ]-Inf , val]
val <- 1.96
pnorm(val , mean = 0 , sd = 1 , lower.tail = TRUE)
# evenement complementaire
pnorm(val , mean = 0 , sd = 1 , lower.tail = FALSE)

# quantile superieur d'ordre alpha
alpha <- 0.025
qnorm(alpha , mean = 0 , sd = 1 , lower.tail = FALSE)
# quantile inferieur d'ordre alpha
qnorm(alpha , mean = 0 , sd = 1 , lower.tail = TRUE)

# densite 
dnorm(val , mean = 0 , sd = 1)
abs <- seq(-3,3,0.1)
plot(abs,dnorm(abs,mean=0,sd=1),type='l')

# fonction de repartition = probas cumulees croissantes
prob <- pnorm(abs,mean=0,sd=1)
plot(abs,prob,type='l')


# les autres lois de probabilites sont construites sur le meme modele
# r... (random) ; d... (densite) ; q... (quantile) ; p... (probabilite)
# loi student : rt , dt , qt , pt
# loi du chi-deux : rchisq , dchisq , qchisq , pchisq
# loi binomiale : rbinom , dbinom , qbinom , pbinom
# taper help('distributions')









