# ************************ #
# Mardi 19 dc. 2017
# SCRIPT 4 - GRAPHIQUES
# ************************ #

rm(list = ls())

dossier <- 'C:/Users/mintsa/Desktop/ARAMIS/Scripts_Presentation'
setwd(dossier)
getwd()


data("airquality")
str(airquality)
help(airquality)
donnees <- airquality
donnees$Month <- as.factor(donnees$Month)
str(donnees)
summary(donnees)

# 1. diagramme circulaire pour variable categorielle
# **************************************************
# creer la variable
couper <- c(0 , 6 , 9  , 13 , 21)
categorie <- cut(donnees$Wind , breaks = couper , include.lowest = TRUE , ordered_result = TRUE)
str(categorie) # 4 categories
summary(categorie)
donnees <- cbind(donnees,categorie)

t <- table(donnees$categorie)
pie (t , col = c('purple','burlywood','chocolate','seagreen') , 
     main = 'Wind _ Categoriel' , border = NA )

# exporter le graphique (il ira dans le dossier defini par setwd())
png(filename="Graphique.png", 
    units = 'px' , width = 480 , height = 480 , pointsize = 12)
pie (t , col = c('purple','burlywood','chocolate','seagreen') , main = 'Wind _ Categoriel')
dev.off()

jpeg(filename="Graphique.jpg", 
    units = 'px' , width = 480 , height = 480 , pointsize = 12)
pie (t , col = c('purple','burlywood','chocolate','seagreen') , main = 'Wind _ Categoriel')
dev.off()
# autres fonctions d'export : svg() , jpeg() , bmp() , etc.


# 2. histogramme pour variable continue
# **************************************************
summary(donnees$Ozone)
hist(donnees$Ozone , freq = TRUE , breaks = seq(0,180,10) , labels = TRUE , ylim=c(0,30) ,
     xlab = 'titre X' , ylab = 'titre Y' , main = 'titre Graph' , col = 4) # effectifs

hist(donnees$Wind , freq = FALSE , breaks = seq(0,24,3) , col=8) # frequence
# superposition d'une fonction de densite
# le x est generique  : 
# R travaille avec les abscisses definies par la fonction de premier niveau (ici, hist)
curve(dnorm(x,mean = mean(donnees$Wind) , sd = sd(donnees$Wind)) , col='deeppink' , 
      add=TRUE , lwd = 2 , lty = 5)  



# 3. Boite a Moustaches (variable quantitative)
# **************************************************

boxplot(donnees[,c(1,4)] , names = c('Ozone','Temperature(F)') )

# traitement avec une formule
# formula : y en fonction de x : y ~ x
boxplot(donnees$Solar.R ~ donnees$Month) # x doit etre de type factor


# coller sur le mme graphique la valeur moyenne
# parametre na.rm pour la moyenne
levels(donnees$Month)
mean(donnees$Solar.R[donnees$Month=='5'],na.rm = TRUE)
mean(donnees$Solar.R[donnees$Month=='6'],na.rm = TRUE)

m <- mean(donnees$Solar.R[donnees$Month=='6'],na.rm = TRUE)
# points est une fonction de second niveau, se colle a un graphique deja existant
# si pas de plot avant --> renvoie une ERROR
# Error in plot.xy(xy.coords(x, y), type = type, ...) : plot.new has not been called yet
# faire reference a la boite placee en 2eme position : ref <- 2
ref <- 2
points(ref , m , col='red', pch = 15 , cex = 2)

# puisance de R : traiter l'ensemble des modalites en une seule ligne, sans boucle
# fonction aggregate()
aggregate(donnees[,1:4] , by = list(donnees$Month) , FUN = mean , na.rm = TRUE)
res <- aggregate(donnees[,1:4] , by = list(donnees$Month) , FUN = mean , na.rm = TRUE)
str(res)
res
points(1:5 , res$Solar.R , col = 4:8 , pch=15)


rm(m,ref,t,categorie,couper,res)



# 4. NUAGE DE POINTS plot (x,y) ou plot(y ~ x)
# **************************************************

# Le niveau d'Ozone peut-il etre explique par la Temperature?

# coefficient de correlation lineaire
cor(donnees$Temp , donnees$Ozone , use = 'complete.obs')

# graphique
plot(donnees$Ozone ~ donnees$Temp , col='navy' , pch = 4)

# tracer la droite de regression lineaire
abline(lm(donnees$Ozone ~ donnees$Temp ) , col='forestgreen' , lwd = 2 , lty = 2)

# ajouter le centre de gravite == point moyen
points(mean(donnees$Temp,na.rm=TRUE) , mean(donnees$Ozone,na.rm=TRUE) , pch=16 , col='firebrick3' , cex = 2)

# coller la valeur du coefficient de correlation lineaire
k <- cor(donnees$Temp , donnees$Ozone , use = 'complete.obs')
text(60 , 110 , cex = 0.8 , labels = paste('coeff cor = ',round(k,3)) , col='chocolate4' , adj = 0)

# mettre une legende
legend('topleft' , legend=c('nuage de points','droite regression','centre gravite') , 
       col=c('navy','forestgreen','firebrick3'),
       pch = c(4,NA,16) , lty=c(NA,2,NA) , lwd = c(1,2,2) , cex = 0.7)


# 9 couleurs basiques de reference qui tournent (9 == 1 = black)
# 1 = black , 2 = red , 3 = green
# 4 = blue , 5 = cyan , 6 = pink
# 7 = yellow , 8 = gray , 0 = white (uniqement avec 0)


# autres fonctions graphiques : segments() , arrows() , lines() , polygon() 


# 5. Graphiques de niveau
# **************************************************

# organiser les donnees : 1 colonne par mois, 30  jours
couper <- split(donnees$Wind , f = donnees$Month)
tampon <- unlist(couper) # nom == xeme valeur pour chaque level du factor
# tous les mois n'ont pas le meme nombre de jours
# enlever le jour 31
tampon <- tampon[-which(substr(names(tampon),2,3)=='31')]
jdd <- matrix(tampon,ncol=nlevels(donnees$Month))

# pour chaque mois (en ordonnee) , et chaque jour (en abscisse), 
# tracer le niveau de la valeur Wind
filled.contour(x = as.numeric(levels(donnees$Month)) , y = 1:nrow(jdd) , z = t(jdd) , 
               levels = c(0 , 10 , 17 , 22) , col= c('cyan3','khaki2','red') )

image(x = as.numeric(levels(donnees$Month)) , y = 1:nrow(jdd) , z = t(jdd) , 
      col= c('cyan3','khaki2','red') , breaks = c(0 , 10 , 17 , 22) ) # 3 niveaux
# je n'ai pas trouve comment ajouter l'echelle
# la premiere couleur correspond au premier niveau : (0,6), etc.
which(jdd>17)



library(corrplot)
# Visualisation d'une matrice de correlation
# ici, fonction detournee : avoir des valeurs entre -1 et 1
max(jdd)
jdd0 <- data.frame(jdd/max(jdd))
summary(jdd0)
str(jdd0)
names(jdd0)<-paste('Mois ',levels(donnees$Month))
row.names(jdd0)<-paste('Jour ',row.names(jdd0))

corrplot(t(jdd0) , method='square' , type = 'full' , cl.lim=c(0,1) , 
         tl.pos = 'lt' , cl.pos = 'r' )
title(main = 'Vitesse du vent, relativement a la valeur maximale observee' , 
      sub = "Sous-titre",
      xlab = "Axe des x", 
      cex.main = 0.8, font.main= 4, col.main= "violetred3",
      cex.sub = 0.75, font.sub = 3, col.sub = "magenta4",
      col.lab ="darkblue")

rm(k,dossier,airquality,donnees)




