# ************************ #
# Mardi 19 dc. 2017
# SCRIPT 4 - IMPORT EXPORT
# ************************ #

rm(list=ls())
dossier <- 'C:/Users/mintsa/Desktop/ARAMIS/Data'
setwd(dossier)
getwd()
dir()
# le fichier .csv ou .txt que l'on veut charger dans R doit se trouver dans ce dossier


# donnees a telecharger depuis le site : 
# http://math.agrocampus-ouest.fr/infoglueDeliverLive/enseignement/support2cours/livres/statistiques.avec.R

# ---------
# IMPORT
# ---------
# importer un fichier .txt ; .csv dans R sous forme d'un data.frame
# read.csv() ;   read.csv2()  ;  read.table()
donnees<-read.csv2('credit.csv' , header=TRUE , sep=';' , 
                   dec = '.', encoding = 'UTF-8' , stringsAsFactors = TRUE)
# stringsAsFactors = TRUE / les variables caracteres sont transformees en variables categorielles
# dec = '.'               / on precise le symbole pour la virgule decimale

# voir si l'importation s'est bien redoule
str(donnees)

# informations generales sur le dataframe
str(donnees)
length(donnees)
mode(donnees)
class(donnees)
dim(donnees)
attributes(donnees)


# si le type de varivable ne convient pas, penser aux fonctions
# as.character , as.factor , as.integer , as.numeric

# infos stats de base
summary(donnees)


# ---------
# EXPORT
# ---------
# sortir les resultats dans un fichier .txt (si on veut dans sous-dossier : ./SOUS_DOSSIER/resume.txt)
dir.exists('./SOUS_DOSSIER')
dir.create('./SOUS_DOSSIER')

sink('resume.txt')
print(summary(donnees))
sink() # pour que l'affichage revienne dans la console, sinon on continue d'ecrire dans le fichier .txt
print(attributes(donnees))


# tableau de contingence - croisement de 2 variables
tampon <- cbind(donnees$Villes,floor(donnees$latitude),floor(donnees$longitude))
t <- table(donnees$Logement , donnees$Profession)
t
sum(t)
str(t)
write(t,file = 'contingence1.csv' , ncolumns = 2 , sep = ';')
write.table(t,file = 'contingence1.txt' , row.names = TRUE , col.names = TRUE , sep = ';')
write.table(t,file = 'contingence2.csv' , row.names = TRUE , col.names = TRUE , sep = ';')
write.csv(t,file = 'contingence3.csv' , row.names = TRUE)
write.csv2(t,file = 'contingence4.csv' , row.names = TRUE) # le plus beau!


# sauvegarde en format .RData
save('donnees',file = 'Jdd.RData') # un objet specifique
save.image(file='ToutWd.RData') # tout l'environnement de travail

rm(list = ls())

# lors d'une prochaine session : charger les donnees (apres avoir defini le work directory ou se trouve l'objet RData)
load('ToutWd.RData')

# Dans le dossier o est enregistre l'objet .RData
# si on clique dessus, on ouvre une session R (pas RStudio)
# pour voir que l'objet est bien charge et disponible dans R, on peut executer la commande ls()
# on verra apparaitre le jeu de donnees





