# ************************ #
# Mardi 19 dc. 2017
# SCRIPT 6 - PACKAGES
# ************************ #


rm(list = ls())

# 1. GESTION DES PACKAGES
# ----------------------------------

# savoir si un package est present dans une librairie de l'ordinateur
find.package("sqldf")
find.package("FactoMineR")

# si le package n'est pas present : aucun package nomm 'xxx' n'est trouv, alors, l'installer
# Condition : avoir une connection Internet pour que RStudio charge en meme temps les dependances
install.packages("FactoMineR")
# un petit stop est alors visible au niveau de la console

# resultat : 
# package 'xxx' successfully unpacked and MD5 sums checked
# The downloaded binary packages are in ...

# desinstaller un package
remove.packages('FactoMineR')
find.package("FactoMineR")


# pour acceder aux fonctions d'un package dans RStudio (2 fonctions possibles)
require("FactoMineR")
library("FactoMineR")

# savoir si le package est accessible dans la session de RStudio
search()



# 2. PACKAGES ggplot2 ou lattice pour des graphes plus elabores
# -------------------------------------------------------------
# permet de realiser des graphiques plus elabores
# https://www.statmethods.net/advgraphs/ggplot2.html
library(ggplot2)
data(airquality)
help(airquality)

qplot(airquality$Wind, airquality$Ozone)
qplot(Temp,Ozone,data=airquality)


# http://www.sthda.com/french/wiki/ggplot2
jdd <- airquality
jdd$Month <- as.factor(jdd$Month)
p <- ggplot(jdd, aes(x=Month, y=Wind, color=Month)) + 
  geom_boxplot(outlier.colour="darkorange", outlier.shape=16,
               outlier.size=5, notch=FALSE) 
p 
p + stat_summary(fun.y=mean, geom="point", shape=15, size=4 , col = 'deeppink')



library(lattice)
# https://www.statmethods.net/advgraphs/trellis.html
levelplot(airquality$Ozone ~ airquality$Wind*airquality$Temp , cuts=3 , 
          col.regions = c('navy','purple','forestgreen','darkorange'))



# 3. PACKAGE FactoMineR
# ----------------------------------
# pour effectuer de l'analyse de donnees : ACP , classification
library(FactoMineR)
data(airquality)
help(airquality)

# une ACP se realise sur des donnees quantitatives (on elimine le jour)
jdd <- airquality[,1:5]
# probleme des donnees manquantes
ligne <- which(is.na(jdd$Ozone) | is.na(jdd$Solar.R))
jdd <- jdd[-ligne,]
res.pca <- PCA(jdd , quanti.sup = 5, scale.unit = TRUE , ncp = ncol(jdd) , graph = TRUE)

# RESULTATS 
# str(res.pca)
res.pca
summary(res.pca)

# les valeurs propres
res.pca$eig
# SCREE PLOT
barplot(res.pca$eig[, 2], names = paste("Dim", 1:nrow(res.pca$eig)) , 
        main='Pourcentage de variance' , col='seagreen2' , las=2)
# les plans factoriels
plot.PCA(res.pca, choix = "var", axes = 2:3, cex = 0.9)


library(factoextra) # pour les graphiques
fviz_eig(res.pca , choice = 'variance' , addlabels = TRUE, ylim = c(0, 35) , 
         geom=c('bar','line') , barfill='snow' , linecolor='deeppink3' , ncp = nombre )
fviz_pca_var(res.pca , col.var = "cos2" , axes=c(1,2) ,  
             gradient.cols = c("#00AFBB", "#E7B800", "#FC4E07"), repel = TRUE)




# 4. PACKAGE sqldf
# ----------------------------------
# pour interroger des bases de donnees avec le langage SQL
# l'exemple presente est un peu artificiel, R fait cela tres bien en manipulation de data.frame
library(sqldf)

# Requete SQL
data(iris)
Ident <- paste('ID',1:nrow(iris),sep='_')
donnees <- data.frame(Ident,iris)
donnees$Ident <- as.character(donnees$Ident)
str(donnees)

bouquet <- rbinom(n = nrow(donnees) , size = 1 , prob = 0.25)
prix <- rnorm(n = nrow(donnees) , mean = 7.5 , sd = 2)
Ident <- paste('ID',floor(seq(1,2*nrow(iris),length.out=nrow(iris))),sep='_')
brouillon <- data.frame(Ident , bouquet ,  prix)
brouillon$Ident <- as.character(brouillon$Ident)
str(brouillon)

# Utilisation de la fonction sqldf() pour ecrire la requete SQL
# stocker le resultat dans un data.frame
DataGroup <- sqldf("SELECT DISTINCT a.Ident , a.Species , b.bouquet AS Offrir , b.prix AS Tarif
                 FROM donnees AS a
                 INNER JOIN brouillon AS b
                 ON (a.Ident = b.Ident);" , method="raw" , row.names=FALSE)
str(DataGroup)
dim(DataGroup)
DataGroup



names(donnees)[2:3] <- c('LongSepal','LargSepal') # probleme du . dans le nom de la variable
DataGroup <- sqldf("SELECT DISTINCT Species , count(*) AS Effectif , 
                   max(LongSepal) AS Maximum , avg(LargSepal) AS Moyenne
                   FROM donnees  
                   GROUP BY Species ;",method="raw",row.names=FALSE)

str(DataGroup)
dim(DataGroup)
DataGroup


rm (list=ls())








